<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServicePackage extends Model
{
    use HasFactory;

    protected $table = 'service_packages';

    protected $fillable = [
        'applicable_make_id',
        'applicable_model_id',
        'type',
        'name',
        'order',
        'price',
        'description',
    ];

    protected static function boot()
    {
        parent::boot();
        self::creating(fn(self $package) => $package->ensureType());
    }

    private function ensureType()
    {
        if (empty($this->attributes['type'])) {
            $this->attributes['type'] = 'package';
        }
    }

    public function scopeSetSortBy(Builder $query, ?string $sortOption): Builder
    {
        if (empty($sortOption) || $sortOption === 'order') {
            return $query->orderBy('order');
        }

        $direction = str_ends_with($sortOption, '_desc') ? 'desc' : 'asc';
        return $query->orderBy(str_replace('_desc', '', $sortOption), $direction);
    }
}
