<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class Role extends \Spatie\Permission\Models\Role
{
    use CentralConnection;

    protected $fillable = [
        'name',
        'guard_name',
        'tenant',
    ];

    protected $visible = [
        'id',
        'name',
        'description',
        'icon',
        'tenant',
    ];

    public function scopeNotMtc(Builder $query)
    {
        $query->where('name', '!=', 'mtc');
    }
}
