<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ResourceView extends Model
{
    protected $table = 'resource_views';

    protected $fillable = [
        'viewable_type',
        'viewable_id',
        'date',
        'hits',
        'quick_view_hits',
        'filter_views',
        'compare_views',
        'compare_email_requests',
    ];

    protected $casts = [
        'date' => 'date',
        'hits' => 'integer',
        'quick_view_hits' => 'integer',
        'filter_views' => 'integer',
        'compare_views' => 'integer',
        'compare_email_requests' => 'integer',
    ];

    /**
     * Get the parent viewable model (Vehicle, VehicleOffer, Page, etc.)
     */
    public function viewable(): MorphTo
    {
        return $this->morphTo();
    }
}
