<?php

namespace Mtc\MercuryDataModels;

use App\ImportConditionRepository;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use OwenIt\Auditing\Contracts\Auditable;

class ReservationPriceRule extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;

    protected $fillable = [
        'import_condition_id',
        'field',
        'condition',
        'value',
        'data',
    ];

    protected $casts = [
        'active' => 'boolean',
        'data' => 'array',
    ];

    protected $appends = [
        'field_name',
        'condition_name',
        'value_name',
    ];

    public function condition(): BelongsTo
    {
        return $this->belongsTo(ReservationPrice::class);
    }

    public function getFieldNameAttribute(): string
    {
        return __('vehicles.' . $this->field);
    }

    public function getConditionNameAttribute(): string
    {
        return __('labels.conditions.' . $this->condition);
    }

    public function getValueNameAttribute()
    {
        return (new ImportConditionRepository())->getValue($this->field, $this->value);
    }
}
