<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\BillableFactory;
use Mtc\MercuryDataModels\Factories\ReportingStatFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class ReportingStat extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'reporting_stats';

    /**
     * Mass assign attributes
     *
     * @var array
     */
    protected $fillable = [
        'key',
        'value',
        'date',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'date' => 'datetime',
    ];

    /**
     * Model factory
     *
     * @return ReportingStatFactory
     */
    protected static function newFactory()
    {
        return ReportingStatFactory::new();
    }
}
