<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class PostcodeCache extends Model
{
    use CentralConnection;

    protected $table = 'postcode_cache';

    protected $fillable = [
        'country',
        'postcode',
        'lat',
        'lng',
    ];

    public function getLatitudeAttribute()
    {
        return $this->lat;
    }

    public function getLongitudeAttribute()
    {
        return $this->lng;
    }
}
