<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NewCarFinance extends Model
{
    protected $table = 'new_car_finance';

    protected $fillable = [
        'new_car_id',
        'provider',
        'final_payment',
        'full_price',
        'deposit',
        'total_amount',
        'total_credit_amount',
        'apr',
        'interest_rate',
        'data',
        'finance_type',
        'term',
        'number_of_payments',
        'monthly_price',
        'first_payment',
        'annual_mileage',
        'customer_deposit',
        'dealer_deposit_contribution',
        'option_to_purchase_fee',
        'excess_mileage_charge',
        'documentation_fee',
        'payable_amount',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    public function car(): BelongsTo
    {
        return $this->belongsTo(NewCar::class, 'new_car_id');
    }
}
