<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\KeyloopLeaseResidualValueFactory;

class KeyloopLeaseResidualValue extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'keyloop_lease_residual_values';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'external_variant_id',
        'contract_length',
        'annual_mileage',
        'residual_value_excluding_vat',
        'residual_value_including_vat',
        'was_recently_synced',
    ];

    protected static function newFactory()
    {
        return KeyloopLeaseResidualValueFactory::new();
    }
}
