<?php

namespace Mtc\MercuryDataModels\Jobs;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\PageHit;

class TrackPageRequest implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    private const SKIP_ROUTES = [
        'pages.show',
        'vehicles.index',
        'vehicles.show',
        'vehicles.compare',
        'valuations.show',
        'dealerships.index',
        'dealerships.show',
        'franchises.index',
        'franchises.show',
        'properties.index',
        'properties.show',
        'offers.index',
        'offers.search',
        'offers.show',
        'new-cars.search',
        'new-cars.show',
    ];

    /**
     * Create a new job instance.
     */
    public function __construct(
        private readonly ?string $uri,
        private readonly ?int $status_code,
        private readonly ?string $route_name,
    ) {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if (empty($this->uri) || !in_array($this->route_name, self::SKIP_ROUTES)) {
            return;
        }

        $hit = PageHit::query()->updateOrCreate([
            'endpoint' => $this->uri,
            'status_code' => $this->status_code,
            'time_window' => Carbon::now()->format('Y-m-d H')
        ]);
        $hit->increment('hits');
    }
}
