<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\InvoicePaymentFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class InvoicePayment extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_payments';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'invoice_id',
        'provider',
        'amount',
        'reference',
        'confirmed_at',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'confirmed_at' => 'datetime',
        'details' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return InvoicePaymentFactory
     */
    protected static function newFactory()
    {
        return InvoicePaymentFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }
}
