<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\InvoiceItemFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class InvoiceItem extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_items';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'billable_id',
        'invoice_id',
        'name',
        'price',
        'discounted_price',
        'quantity',
        'line_total',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'details' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return InvoiceItemFactory
     */
    protected static function newFactory()
    {
        return InvoiceItemFactory::new();
    }

    /**
     * Relationship with invoice
     *
     * @return BelongsTo
     */
    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }
}
