<?php

namespace Mtc\MercuryDataModels\Finance\Contracts;

use Carbon\Carbon;

class FinanceRequestData
{
    public function __construct(
        public readonly string $uuid,
        public readonly ?string $registration_number,
        public readonly ?string $cap_id,
        public readonly string $dealer_id,
        public readonly ?int $engine_size,
        public readonly string $condition,
        public readonly ?Carbon $registration_date,
        public readonly int $term,
        public readonly ?int $mileage,
        public readonly int $annual_mileage,
        public readonly float $price,
        public readonly float $deposit,
        public readonly string $credit_rating,
        public readonly string $vehicle_type = 'car',
        public readonly ?string $clientKey = null,
        public readonly ?int $finance_option = null,
        public array $extra = [],
        public readonly ?string $vin = null,
        public readonly bool $is_new = false,
        public readonly ?string $make_name = null,
        public readonly ?bool $is_vat_applicable = false,
    ) {
        //
    }
}
