<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\VehicleStandardEquipment;
use Mtc\MercuryDataModels\VehicleValuation;

class VehicleValuationFactory extends Factory
{
    protected $model = VehicleValuation::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'user_id' => null,
            'provider' => 'auto-trader',
            'registration' => Str::random(6),
            'mileage' => random_int(10000, 200000),
            'vehicle_type' => 'car',
            'make' => $this->faker->word(),
            'model' => $this->faker->word(),
            'derivative' => $this->faker->word(),
            'fuel_type' => $this->faker->word(),
            'engine_size' => $this->faker->word(),
            'body_type' => $this->faker->word(),
            'transmission' => $this->faker->word(),
            'date_of_registration' => $this->faker->date(),
            'valuation_made_at' => $this->faker->date(),
            'retail_price' => random_int(200, 20000),
            'average_price' => random_int(200, 20000),
            'clean_price' => random_int(200, 20000),
            'below_price' => random_int(200, 20000),
            'errors' => [],
        ];
    }
}
