<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\VehicleTechnicalData;

class VehicleTechDataFactory extends Factory
{
    protected $model = VehicleTechnicalData::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'vehicle_id' => random_int(1, 100),
            'vehicle_type' => $this->faker->word(),
            'description' => $this->faker->sentence(),
            'category' => $this->faker->word(),
            'value' => $this->faker->word(),
            'code' => Str::random(5),
        ];
    }
}
