<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\VehicleStandardEquipment;

class VehicleSpecFactory extends Factory
{
    protected $model = VehicleStandardEquipment::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'vehicle_id' => random_int(1, 100),
            'vehicle_type' => $this->faker->word(),
            'feature_id' => random_int(1, 100),
            'type' => $this->faker->word(),
            'description' => $this->faker->sentence(),
            'category' => $this->faker->word(),
            'price' => random_int(0, 200),
            'vat_amount' => random_int(0, 100),
            'code' => Str::random(5),
        ];
    }
}
