<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\ContentManager\PageStatus;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleOfferContentHistory;

class VehicleOfferContentHistoryFactory extends Factory
{
    protected $model = VehicleOfferContentHistory::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'uuid' => Str::random(32),
            'offer_id' => random_int(1, 100),
            'author_id' => random_int(1, 100),
            'is_active' => false,
            'pending_review' => random_int(0, 1),
            'request_changes' => random_int(0, 1),
            'data' => [],
        ];
    }
}
