<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\PageStatus;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleOfferContent;

class VehicleOfferContentFactory extends Factory
{
    protected $model = VehicleOfferContent::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'offer_id' => random_int(1, 10),
            'parent_id' => random_int(1, 10),
            'global_content_id' => random_int(1, 10),
            'element_id' => random_int(1, 10),
            'name' => $this->faker->word(),
            'content' => json_encode([]),
            'search_content' => random_int(1, 10),
        ];
    }
}
