<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\VehicleFeature;
use Mtc\MercuryDataModels\VehicleStandardEquipment;

class VehicleFeatureFactory extends Factory
{
    protected $model = VehicleFeature::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'vehicle_id' => random_int(1, 100),
            'vehicle_type' => random_int(0, 1) ? 'vehicle' : 'offer',
            'name' => $this->faker->word(),
            'slug' => Str::slug($this->faker->word()),
            'category' => $this->faker->word(),
            'conditions' => [],
        ];
    }
}
