<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\Billable;
use Mtc\MercuryDataModels\TenantBillable;

class TenantBillableFactory extends Factory
{
    protected $model = TenantBillable::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'tenant_id' => random_int(0, 50),
            'billable_id' => Billable::factory()->create(),
            'price' => random_int(10, 5000),
            'discounted_price' => random_int(0, 5) ? 0 : random_int(5, 1000),
            'quantity' => random_int(0, 3) ? 1 : random_int(1, 5),
            'notes' => $this->faker->paragraph(),
        ];
    }
}
