<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\Setting;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\Setting>
 */
class SettingFactory extends Factory
{
    protected $model = Setting::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'tab' => $this->faker->word(),
            'section' => $this->faker->word(),
            'group' => $this->faker->word(),
            'name' => $this->faker->sentence(),
            'config_key' => $this->faker->words(3, true),
            'type' => 'string',
            'value' => $this->faker->word(),
            'validation_rules' => json_encode([]),
            'description' => $this->faker->sentence(),
        ];
    }
}
