<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\SeoData;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\SeoDefault>
 */
class SeoDataFactory extends Factory
{
    protected $model = SeoData::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'path' => '/' . $this->faker->word() . Str::random(5),
            'title' => $this->faker->sentence(),
            'description' => $this->faker->sentence(),
            'heading' => $this->faker->sentence(),
        ];
    }
}
