<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\VehicleModel;

class KeyloopLeaseVehicleVariantFactory extends Factory
{
    protected $model = KeyloopLeaseVehicleVariant::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $vehicle_model = VehicleModel::factory()->createOne();
        return [
            'external_variant_id' => Str::random(),
            'slug' => $this->faker->word(),
            'make_id' => $vehicle_model->make_id,
            'model_id' => $vehicle_model,
            'transmission_id' => TransmissionType::factory()->createOne(),
            'fuel_type_id' => FuelType::factory()->createOne(),
            'body_style_id' => BodyStyleType::factory()->createOne(),
            'door_count' => random_int(3, 5),
            'seats' => random_int(3, 5),
            'engine_size_cc' => random_int(800, 3500),
            'co2' => (random_int(2000, 21000) / 100),
            'type' => $this->faker->name(),
            'price_ex_vat_ex_vrt' => random_int(30000, 90000),
            'cheapest_monthly_price_ex_vat' => random_int(150, 900),
            'delivery_ex_vat_ex_vrt' => random_int(50, 300),
            'vehicle_vrt' => random_int(3000, 9000),
        ];
    }
}
