<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\InvoiceHistory;
use Mtc\MercuryDataModels\InvoiceHistoryType;

class InvoiceHistoryFactory extends Factory
{
    protected $model = InvoiceHistory::class;
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'invoice_id' => random_int(0, 50),
            'type' => array_rand(InvoiceHistoryType::cases()),
            'title' => $this->faker->sentence(),
            'details' => [],
        ];
    }
}
