<?php

namespace Mtc\MercuryDataModels\Factories;

use App\Models\ContentSync;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ContentSync>
 */
class ContentSyncFactory extends Factory
{
    protected $model = ContentSync::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'tenant_id' => Str::random(16),
            'user_id' => random_int(1, 100),
            'token' => Str::random(24),
            'details' => [],
            'finished' => random_int(0, 1),
            'failed' => random_int(0, 1),
            'errors' => [],
        ];
    }
}
