<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\Colour;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\Colour>
 */
class ColourFactory extends Factory
{
    protected $model = Colour::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'colour' => implode(' ', $this->faker->words(2)),
            'hex_code' => $this->faker->hexColor(),
        ];
    }
}
