<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CarConfiguratorEngine;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfiguratorEngineFactory extends Factory
{
    protected $model = CarConfiguratorEngine::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->word,
            'short_description' => $this->faker->sentence(),
            'price' => random_int(1, 10000),
            'model_id' => random_int(1, 1000),
            'fuel_type_id' => random_int(1, 1000),
            'drivetrain_id' => random_int(1, 1000),
            'transmission_id' => random_int(1, 1000),
            'fuel_consumption_combined' => random_int(1, 1000),
            'bhp' => random_int(1, 1000),
            'max_ev_power' => random_int(1, 1000),
            'max_engine_power' => random_int(1, 1000),
            'torque' => random_int(1, 1000),
            'zero_to_sixty' => random_int(1, 1000),
            'fuel_capacity' => random_int(1, 1000),
            'ev_range' => random_int(1, 1000),
        ];
    }
}
