<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CustomerCarConfiguration;
use Ramsey\Uuid\Uuid;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfigurationFactory extends Factory
{
    protected $model = CustomerCarConfiguration::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'uuid' => Uuid::uuid4(),
            'email' => $this->faker->email(),
            'phone_number' => $this->faker->phoneNumber(),
            'name' => $this->faker->name(),
            'customer_id' => random_int(1, 1000),
            'enquiry_id' => random_int(1, 1000),
            'model_id' => random_int(1, 1000),
            'views' => random_int(1, 1000),
        ];
    }
}
