<?php

namespace Mtc\MercuryDataModels\Enums;

enum VehicleSubscriptionEventType: string
{
    case PRICE_DROP = 'price_drop';
    case IMAGES_ADDED = 'images_added';
    case VIDEO_ADDED = 'video_added';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::PRICE_DROP => 'Price Drop',
            self::IMAGES_ADDED => 'New Images Added',
            self::VIDEO_ADDED => 'Video Added',
        };
    }
}
