<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Contracts\Content;
use Mtc\MercuryDataModels\Contracts\ContentModel;
use Mtc\MercuryDataModels\Factories\DealershipContentFactory;
use Mtc\MercuryDataModels\Factories\VehicleOfferContentFactory;
use OwenIt\Auditing\Contracts\Auditable;

class DealershipContent extends Content implements ContentModel, Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'dealership_content';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'global_content_id',
        'element_id',
        'dealership_id',
        'parent_id',
        'template_element_id',
        'slug',
        'name',
        'content',
        'search_content',
        'data',
        'order',
    ];

    /**
     * Model factory
     *
     * @return DealershipContentFactory
     */
    protected static function newFactory()
    {
        return DealershipContentFactory::new();
    }

    /**
     * Relationship with dealership
     *
     * @return BelongsTo
     */
    public function dealership(): BelongsTo
    {
        return $this->belongsTo(Dealership::class);
    }

    /**
     * Relationship with content elements that are nested under this element
     *
     * @return HasMany
     */
    public function subContent(): HasMany
    {
        return $this->hasMany(static::class, 'parent_id');
    }

    /**
     * Relationship with content element that defines structure of this element
     *
     * @return BelongsTo
     */
    public function contentElement(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.element_model'), 'element_id');
    }

    /**
     * Relationship with global content element (if global element added instead of normal one)
     *
     * @return BelongsTo
     */
    public function globalContent(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.global_content_model'), 'global_content_id');
    }
}
