<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class Country extends Model
{
    use HasFactory;
    use CentralConnection;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'countries';

    /**
     * Get the number plate regex for the country
     *
     * @param string $country
     * @return ?string
     */
    public static function numberPlateRegex(string $country): ?string
    {
        return Country::query()
            ->where('code', $country)
            ->whereNotNull('number_plate_regex')
            ->firstOrFail()
            ->number_plate_regex;
    }

    /**
     * Normalize number plate to uniform format
     *
     * @param string $country
     * @param string $vrm
     * @param bool $skip
     * @return string
     */
    public static function normalizeNumberPlate(string $country, string $vrm, bool $skip = false): string
    {
        // Simple implementation just now, might need to do a cleaner approach when expanding to multiple countries
        if ($country === 'GB' && $skip === false) {
            $vrm = str_replace(' ', '', strtoupper($vrm));
            return substr($vrm, 0, 4) . ' ' .  substr($vrm, 4);
        }

        return strtoupper($vrm);
    }
}
