<?php

namespace Mtc\MercuryDataModels;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Support\Facades\Log;
use Mtc\MercuryDataModels\Factories\ConversionFactory;

class Conversion extends Model
{
    use HasFactory;

    protected $fillable = [
        'owner_type',
        'owner_id',
        'type',
        'date',
        'hits',
    ];

    protected static function newFactory()
    {
        return ConversionFactory::new();
    }

    public function owner(): MorphTo
    {
        return $this->morphTo('owner');
    }

    public static function track(Model $model, string $type, ?Carbon $when): void
    {
        Log::debug('search for tracked model', [
            'owner_type' => $model->getMorphClass(),
            'owner_id' => $model->id,
            'type' => $type,
            'date' => $when ?? Carbon::now()->format('Y-m-d'),
        ]);
        $entry = static::query()
            ->firstOrCreate([
                'owner_type' => $model->getMorphClass(),
                'owner_id' => $model->id,
                'type' => $type,
                'date' => $when
                    ? $when->format('Y-m-d')
                    : Carbon::now()->format('Y-m-d'),
            ]);
        $entry->increment('hits');
    }
}
