<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Comment extends \Mtc\ContentManager\Contracts\Comment
{
    /**
     * Relationship with users tagging in comments
     *
     * @return BelongsToMany
     */
    public function taggedUsers(): BelongsToMany
    {
        return $this->belongsToMany(
            config('auth.providers.users.model'),
            tenant()->database()->getName() . '.comment_tagged_users'
        );
    }
}
