<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CatalogOfferFactory;
use OwenIt\Auditing\Contracts\Auditable;

class CatalogOffer extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    use HasMedia;

    public const TYPE_VEHICLE = 'vehicle';
    public const TYPE_NEW_CAR = 'new_car';

    protected $fillable = [
        'name',
        'subtitle',
        'link',
        'button_text',
        'active',
        'type',
    ];

    protected $attributes = [
        'type' => 'vehicle',
    ];

    protected static function newFactory()
    {
        return CatalogOfferFactory::new();
    }

    public function vehicles(): BelongsToMany
    {
        return $this->belongsToMany(Vehicle::class);
    }

    public function rules(): HasMany
    {
        return $this->hasMany(CatalogOfferRule::class);
    }

    /**
     * Define thumbnail sizes to auto-generate for this model
     *
     * @return mixed
     */
    public function getDefaultAllowedMediaSizesAttribute()
    {
        return Config::get('automotive.catalog_offers_sizes', []);
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('active', 1);
    }

    public function scopeOfType(Builder $query, string $type): void
    {
        $query->where('type', $type);
    }

    public function scopeForVehicles(Builder $query): void
    {
        $query->where('type', self::TYPE_VEHICLE);
    }

    public function scopeForNewCars(Builder $query): void
    {
        $query->where('type', self::TYPE_NEW_CAR);
    }
}
