<?php

namespace Mtc\MercuryDataModels;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Contracts\Auditable;

class BookingAvailability extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;

    protected $table = 'service_location_availability';

    protected $fillable = [
        'dealership_id',
        'email',
        'active',
        'number_of_bays',
        'time_windows',
        'mondays',
        'tuesdays',
        'wednesdays',
        'thursdays',
        'fridays',
        'saturdays',
        'sundays',
        'min_days_in_future_for_booking',
        'max_days_in_future_for_booking',
    ];

    protected $casts = [
        'active' => 'boolean',
        'time_windows' => 'array',
        'mondays' => 'boolean',
        'tuesdays' => 'boolean',
        'wednesdays' => 'boolean',
        'thursdays' => 'boolean',
        'fridays' => 'boolean',
        'saturdays' => 'boolean',
        'sundays' => 'boolean',
    ];

    public function dealership(): BelongsTo
    {
        return $this->belongsTo(Dealership::class, 'dealership_id');
    }

    public function holidays(): HasMany
    {
        return $this->hasMany(BookingAvailabilityHoliday::class, 'availability_id');
    }

    public function upcomingHolidays(): HasMany
    {
        return $this->hasMany(BookingAvailabilityHoliday::class, 'availability_id')
            ->where('holiday_date', '>=', Carbon::now()->startOfDay());
    }

    public function allocateHolidays(array $holidays): void
    {
        collect($holidays)
            ->unique()
            ->each(fn ($holiday) => $this->upcomingHolidays()->updateOrCreate(['holiday_date' => $holiday]));
    }
}
