<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;

class ApiNotification extends Model
{
    protected $table = 'api_notifications';

    protected $casts = [
        'processed' => 'boolean',
        'data' => 'array',
        'headers' => 'array',
        'created_at' => 'datetime:d/m/Y H:i',
    ];

    protected $fillable = [
        'provider',
        'data',
        'headers',
        'processed',
        'data_model',
        'reference',
    ];

    protected static function boot()
    {
        parent::boot();

        self::created(fn(self $record) => $record->cleanOldReferences($record));
    }

    private function cleanOldReferences(self $notification): void
    {
        if (empty($notification->reference)) {
            // Only when reference is set
            return;
        }

        // Delete all but most recent entries of this notification
        $older_record = self::query()
            ->where('provider', $notification->provider)
            ->where('reference', $notification->reference)
            ->latest()
            ->skip(5)
            ->first();

        if ($older_record) {
            self::query()
                ->where('provider', $notification->provider)
                ->where('reference', $notification->reference)
                ->where('id', '<', $older_record->id)
                ->delete();
        }
    }
}
