CREATE TABLE IF NOT EXISTS "migrations" ("id" integer primary key autoincrement not null, "migration" varchar not null, "batch" integer not null);

DROP TABLE IF EXISTS `api_tokens`;
CREATE TABLE `api_tokens` (
  `id` INTEGER NOT NULL,
  `api_user_id` INTEGER NOT NULL,
  `token_type` TEXT NOT NULL,
  `token` TEXT NOT NULL,
  `expires_at` TEXT NOT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `api_usage`;
CREATE TABLE `api_usage` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT DEFAULT NULL,
  `api_user_id` INTEGER DEFAULT NULL,
  `api_token_id` INTEGER DEFAULT NULL,
  `endpoint` TEXT NOT NULL,
  `method` TEXT DEFAULT NULL,
  `time_window` TEXT DEFAULT NULL,
  `hits` INTEGER DEFAULT NULL,
  `avg` REAL DEFAULT NULL,
  `min` REAL DEFAULT NULL,
  `max` REAL DEFAULT NULL,
  `slow_3s` INTEGER DEFAULT 0,
  `slow_10s` INTEGER DEFAULT 0,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `api_usage_snapshots`;
CREATE TABLE `api_usage_snapshots` (
  `id` INTEGER NOT NULL,
  `api_usage_id` INTEGER NOT NULL,
  `input` TEXT DEFAULT NULL,
  `request_time` REAL DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `api_user_tenants`;
CREATE TABLE `api_user_tenants` (
  `id` INTEGER NOT NULL,
  `api_user_id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `api_users`;
CREATE TABLE `api_users` (
  `id` INTEGER NOT NULL,
  `name` TEXT NOT NULL,
  `is_active` INTEGER NOT NULL DEFAULT 0,
  `client_id` TEXT DEFAULT NULL,
  `client_secret` TEXT DEFAULT NULL,
  `token_type` TEXT NOT NULL DEFAULT 'oauth',
  `credentials_last_updated_at` TEXT DEFAULT NULL,
  `credentials_due_for_update_at` TEXT DEFAULT NULL,
  `notes` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `billables`;
CREATE TABLE `billables` (
  `id` INTEGER NOT NULL,
  `code` TEXT NOT NULL,
  `type` TEXT NOT NULL,
  `name` TEXT NOT NULL,
  `description` TEXT DEFAULT NULL,
  `price` REAL NOT NULL,
  `active` INTEGER NOT NULL DEFAULT 0,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `body_styles`;
CREATE TABLE `body_styles` (
  `id` INTEGER NOT NULL,
  `slug` TEXT DEFAULT NULL,
  `name` TEXT NOT NULL,
  `autotrader_id` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `type` TEXT DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `content_syncs`;
CREATE TABLE `content_syncs` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `user_id` INTEGER NOT NULL,
  `token` TEXT NOT NULL,
  `finished` INTEGER DEFAULT NULL,
  `failed` INTEGER DEFAULT NULL,
  `details` TEXT DEFAULT NULL,
  `errors` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `data` TEXT DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `id` INTEGER NOT NULL,
  `status` INTEGER NOT NULL DEFAULT 1,
  `order` INTEGER NOT NULL DEFAULT 0,
  `code` TEXT NOT NULL DEFAULT '',
  `name` TEXT NOT NULL DEFAULT '',
  `currency_code` TEXT DEFAULT NULL,
  `north` REAL DEFAULT NULL,
  `south` REAL DEFAULT NULL,
  `east` REAL DEFAULT NULL,
  `west` REAL DEFAULT NULL,
  `capital_name` TEXT DEFAULT NULL,
  `continent_name` TEXT DEFAULT NULL,
  `continent_code` TEXT DEFAULT NULL,
  `languages` TEXT DEFAULT NULL,
  `iso_code` TEXT DEFAULT NULL,
  `dial_code` TEXT DEFAULT NULL,
  `is_eu` INTEGER NOT NULL DEFAULT 0,
  `has_postcodes` INTEGER NOT NULL DEFAULT 1,
  `postcode_regex` TEXT DEFAULT NULL,
  `number_plate_regex` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE `currencies` (
  `id` INTEGER NOT NULL,
  `code` TEXT NOT NULL,
  `ratio` REAL NOT NULL DEFAULT 0.0000,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `domains`;
CREATE TABLE `domains` (
  `id` INTEGER NOT NULL,
  `domain` TEXT NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `verified` INTEGER DEFAULT NULL,
  `ssl_verified` INTEGER DEFAULT NULL,
  `primary` INTEGER DEFAULT NULL,
  `temporary` INTEGER DEFAULT NULL,
  `force` INTEGER DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `drivetrains`;
CREATE TABLE `drivetrains` (
  `id` INTEGER NOT NULL,
  `slug` TEXT DEFAULT NULL,
  `name` TEXT NOT NULL,
  `autotrader_id` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `export_map_templates`;
CREATE TABLE `export_map_templates` (
  `id` INTEGER NOT NULL,
  `is_published` INTEGER NOT NULL DEFAULT 0,
  `sales_channel` TEXT DEFAULT NULL,
  `title` TEXT NOT NULL,
  `type` TEXT NOT NULL DEFAULT 'vehicle',
  `columns` TEXT DEFAULT NULL,
  `headers` TEXT DEFAULT NULL,
  `mapping_rules` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `external_service_usage`;
CREATE TABLE `external_service_usage` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `service` TEXT NOT NULL,
  `section` TEXT NOT NULL,
  `hits` INTEGER NOT NULL DEFAULT 0,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` INTEGER NOT NULL,
  `uuid` TEXT NOT NULL,
  `connection` TEXT NOT NULL,
  `queue` TEXT NOT NULL,
  `payload` TEXT NOT NULL,
  `exception` TEXT NOT NULL,
  `failed_at` TEXT NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `fuel_types`;
CREATE TABLE `fuel_types` (
  `id` INTEGER NOT NULL,
  `slug` TEXT DEFAULT NULL,
  `name` TEXT NOT NULL,
  `autotrader_id` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `ev_data` INTEGER DEFAULT NULL,
  `mpg_data` INTEGER DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `go_live_tasks`;
CREATE TABLE `go_live_tasks` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `task` TEXT NOT NULL,
  `last_triggered_at` TEXT DEFAULT NULL,
  `completed_at` TEXT DEFAULT NULL,
  `failed_at` TEXT DEFAULT NULL,
  `completed_by` INTEGER DEFAULT NULL,
  `details` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `invoices`;
CREATE TABLE `invoices` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `email` TEXT NOT NULL,
  `status` TEXT NOT NULL,
  `due_at` TEXT NOT NULL,
  `paid_at` TEXT DEFAULT NULL,
  `amount` REAL NOT NULL,
  `amount_paid` REAL NOT NULL DEFAULT 0.00,
  `vat_rate` INTEGER DEFAULT NULL,
  `data` TEXT DEFAULT NULL,
  `pdf_path` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `invoice_addresses`;
CREATE TABLE `invoice_addresses` (
  `id` INTEGER NOT NULL,
  `invoice_id` INTEGER DEFAULT NULL,
  `type` TEXT NOT NULL,
  `title` TEXT DEFAULT NULL,
  `first_name` TEXT DEFAULT NULL,
  `last_name` TEXT DEFAULT NULL,
  `address1` TEXT DEFAULT NULL,
  `address2` TEXT DEFAULT NULL,
  `city` TEXT DEFAULT NULL,
  `county` TEXT DEFAULT NULL,
  `postcode` TEXT DEFAULT NULL,
  `state` TEXT DEFAULT NULL,
  `country` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `invoice_history`;
CREATE TABLE `invoice_history` (
  `id` INTEGER NOT NULL,
  `invoice_id` INTEGER NOT NULL,
  `type` TEXT NOT NULL,
  `title` TEXT NOT NULL,
  `details` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `invoice_items`;
CREATE TABLE `invoice_items` (
  `id` INTEGER NOT NULL,
  `invoice_id` INTEGER DEFAULT NULL,
  `billable_id` INTEGER DEFAULT NULL,
  `name` TEXT DEFAULT NULL,
  `price` REAL NOT NULL,
  `discounted_price` REAL DEFAULT NULL,
  `quantity` INTEGER NOT NULL DEFAULT 1,
  `line_total` REAL NOT NULL,
  `details` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `invoice_payments`;
CREATE TABLE `invoice_payments` (
  `id` INTEGER NOT NULL,
  `invoice_id` INTEGER DEFAULT NULL,
  `provider` TEXT NOT NULL,
  `amount` REAL NOT NULL,
  `reference` TEXT NOT NULL,
  `confirmed_at` TEXT DEFAULT NULL,
  `details` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` INTEGER NOT NULL,
  `migration` TEXT NOT NULL,
  `batch` INTEGER NOT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` INTEGER NOT NULL,
  `model_type` TEXT NOT NULL,
  `model_id` INTEGER NOT NULL,
  `tenant_id` INTEGER DEFAULT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`)
);

DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` INTEGER NOT NULL,
  `model_type` TEXT NOT NULL,
  `model_id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL DEFAULT '',
  PRIMARY KEY (`role_id`,`model_type`,`model_id`,`tenant_id`)
);

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `email` TEXT NOT NULL,
  `token` TEXT NOT NULL,
  `created_at` TEXT NULL DEFAULT NULL
);

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` INTEGER NOT NULL,
  `name` TEXT NOT NULL,
  `guard_name` TEXT NOT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` INTEGER NOT NULL,
  `tokenable_type` TEXT NOT NULL,
  `tokenable_id` INTEGER NOT NULL,
  `name` TEXT NOT NULL,
  `token` TEXT NOT NULL,
  `abilities` TEXT DEFAULT NULL,
  `last_used_at` TEXT NULL DEFAULT NULL,
  `expires_at` TEXT NULL DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `postcode_cache`;
CREATE TABLE `postcode_cache` (
  `id` INTEGER NOT NULL,
  `country` TEXT NOT NULL,
  `postcode` TEXT NOT NULL,
  `lat` REAL DEFAULT NULL,
  `lng` REAL DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `release_notes`;
CREATE TABLE `release_notes` (
  `id` INTEGER NOT NULL,
  `is_published` INTEGER NOT NULL,
  `published_at` TEXT DEFAULT NULL,
  `title` TEXT NOT NULL,
  `content` TEXT DEFAULT NULL,
  `data` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` INTEGER NOT NULL,
  `role_id` INTEGER NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`)
);

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` INTEGER NOT NULL,
  `tenant_id` INTEGER DEFAULT NULL,
  `name` TEXT NOT NULL,
  `guard_name` TEXT NOT NULL,
  `description` TEXT DEFAULT NULL,
  `icon` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `tenant` TEXT DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `seeds`;
CREATE TABLE `seeds` (
  `id` INTEGER NOT NULL,
  `seeder` TEXT NOT NULL,
  `batch` INTEGER DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `system_alerts`;
CREATE TABLE `system_alerts` (
  `id` INTEGER NOT NULL,
  `alert_type` TEXT NOT NULL,
  `last_sent_at` TEXT NULL DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `taxonomy_map`;
CREATE TABLE `taxonomy_map` (
  `id` INTEGER NOT NULL,
  `taxonomy_type` TEXT DEFAULT NULL,
  `taxonomy_id` INTEGER DEFAULT NULL,
  `term` TEXT NOT NULL,
  `provider` TEXT NOT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `details` TEXT DEFAULT NULL,
  `parent_id` INTEGER DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `taxonomy_mapables`;
CREATE TABLE `taxonomy_mapables` (
  `id` INTEGER NOT NULL,
  `tenant` TEXT NOT NULL,
  `taxonomy_map_id` INTEGER NOT NULL,
  `mappable_type` TEXT NOT NULL,
  `mappable_id` INTEGER NOT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `telescope_entries`;
CREATE TABLE `telescope_entries` (
  `sequence` INTEGER NOT NULL,
  `uuid` TEXT NOT NULL,
  `batch_id` TEXT NOT NULL,
  `family_hash` TEXT DEFAULT NULL,
  `should_display_on_index` INTEGER NOT NULL DEFAULT 1,
  `type` TEXT NOT NULL,
  `content` TEXT NOT NULL,
  `created_at` TEXT DEFAULT NULL,
  PRIMARY KEY (`sequence`)
);

DROP TABLE IF EXISTS `telescope_entries_tags`;
CREATE TABLE `telescope_entries_tags` (
  `entry_uuid` TEXT NOT NULL,
  `tag` TEXT NOT NULL
);

DROP TABLE IF EXISTS `telescope_monitoring`;
CREATE TABLE `telescope_monitoring` (
  `tag` TEXT NOT NULL
);

DROP TABLE IF EXISTS `tenants`;
CREATE TABLE `tenants` (
  `id` TEXT NOT NULL,
  `name` TEXT DEFAULT NULL,
  `suspended_at` TEXT DEFAULT NULL,
  `suspended_by` INTEGER DEFAULT NULL,
  `suspended_message` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `data` TEXT DEFAULT NULL,
  `last_invoice_created_at` TEXT DEFAULT NULL,
  `next_invoice_due_at` TEXT DEFAULT NULL,
  `tier` TEXT DEFAULT NULL,
  `port_number` INTEGER DEFAULT NULL,
  `live_at` TEXT DEFAULT NULL,
  `marked_live_by` INTEGER DEFAULT NULL,
  `has_cloudflare` INTEGER DEFAULT NULL,
  `cloudflare_data` TEXT DEFAULT NULL,
  `type` TEXT NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `tenant_billables`;
CREATE TABLE `tenant_billables` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `billable_id` INTEGER NOT NULL,
  `price` REAL NOT NULL,
  `discounted_price` REAL DEFAULT NULL,
  `quantity` INTEGER NOT NULL DEFAULT 1,
  `notes` TEXT DEFAULT NULL,
  `billed_from` TEXT DEFAULT NULL,
  `billed_until` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `deleted_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `tenant_billing_details`;
CREATE TABLE `tenant_billing_details` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `vat_rate` INTEGER NOT NULL DEFAULT 20,
  `billing_email` TEXT NOT NULL,
  `contact_no` TEXT DEFAULT NULL,
  `title` TEXT DEFAULT NULL,
  `first_name` TEXT NOT NULL,
  `last_name` TEXT NOT NULL,
  `address1` TEXT DEFAULT NULL,
  `address2` TEXT DEFAULT NULL,
  `city` TEXT DEFAULT NULL,
  `county` TEXT DEFAULT NULL,
  `postcode` TEXT DEFAULT NULL,
  `country` TEXT DEFAULT NULL,
  `state` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `tenant_features`;
CREATE TABLE `tenant_features` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `feature` TEXT NOT NULL,
  `data` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `tenant_users`;
CREATE TABLE `tenant_users` (
  `id` INTEGER NOT NULL,
  `user_id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `role` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `transmissions`;
CREATE TABLE `transmissions` (
  `id` INTEGER NOT NULL,
  `slug` TEXT DEFAULT NULL,
  `name` TEXT NOT NULL,
  `autotrader_id` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `two_factor_remembered_devices`;
CREATE TABLE `two_factor_remembered_devices` (
  `id` INTEGER NOT NULL,
  `user_id` INTEGER NOT NULL,
  `token` TEXT NOT NULL,
  `user_agent` TEXT DEFAULT NULL,
  `ip_address` TEXT DEFAULT NULL,
  `expires_at` TEXT NOT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `user_dashboard_widgets`;
CREATE TABLE `user_dashboard_widgets` (
  `id` INTEGER NOT NULL,
  `tenant_id` TEXT DEFAULT NULL,
  `user_id` INTEGER NOT NULL,
  `section` TEXT NOT NULL,
  `position` INTEGER NOT NULL,
  `kind` TEXT NOT NULL,
  `widget` TEXT NOT NULL,
  `data` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `user_favourite_sites`;
CREATE TABLE `user_favourite_sites` (
  `id` INTEGER NOT NULL,
  `user_id` INTEGER NOT NULL,
  `tenant_id` TEXT NOT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` INTEGER NOT NULL,
  `name` TEXT NOT NULL,
  `email` TEXT NOT NULL,
  `email_verified_at` TEXT NULL DEFAULT NULL,
  `password` TEXT NOT NULL,
  `two_factor_secret` TEXT DEFAULT NULL,
  `two_factor_recovery_codes` TEXT DEFAULT NULL,
  `two_factor_confirmed_at` TEXT NULL DEFAULT NULL,
  `requires_password_change` INTEGER NOT NULL DEFAULT 1,
  `last_login_at` TEXT DEFAULT NULL,
  `remember_token` TEXT DEFAULT NULL,
  `profile_photo_path` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `release_notes_checked_at` TEXT DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `valuations`;
CREATE TABLE `valuations` (
  `id` INTEGER NOT NULL,
  `user_id` INTEGER DEFAULT NULL,
  `provider` TEXT NOT NULL,
  `registration` TEXT NOT NULL,
  `mileage` INTEGER NOT NULL,
  `vehicle_type` TEXT DEFAULT NULL,
  `make` TEXT DEFAULT NULL,
  `model` TEXT DEFAULT NULL,
  `derivative` TEXT DEFAULT NULL,
  `fuel_type` TEXT DEFAULT NULL,
  `engine_size` TEXT DEFAULT NULL,
  `body_type` TEXT DEFAULT NULL,
  `transmission` TEXT DEFAULT NULL,
  `date_of_registration` TEXT DEFAULT NULL,
  `valuation_made_at` TEXT DEFAULT NULL,
  `retail_price` REAL DEFAULT NULL,
  `average_price` REAL DEFAULT NULL,
  `clean_price` REAL DEFAULT NULL,
  `below_price` REAL DEFAULT NULL,
  `errors` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `colour` TEXT DEFAULT NULL,
  `data` TEXT DEFAULT NULL,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `vehicle_makes`;
CREATE TABLE `vehicle_makes` (
  `id` INTEGER NOT NULL,
  `slug` TEXT DEFAULT NULL,
  `name` TEXT NOT NULL,
  `autotrader_id` TEXT DEFAULT NULL,
  `logo` TEXT DEFAULT NULL,
  `monochrome_logo` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `primary_colour` TEXT DEFAULT NULL,
  `secondary_colour` TEXT DEFAULT NULL,
  `cap_id` TEXT DEFAULT NULL,
  `lcv_cap_id` TEXT DEFAULT NULL,
  `keyloop_id` TEXT DEFAULT NULL,
  `cars` INTEGER NOT NULL DEFAULT 0,
  `lcvs` INTEGER NOT NULL DEFAULT 0,
  `motorcycles` INTEGER NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
);

DROP TABLE IF EXISTS `vehicle_models`;
CREATE TABLE `vehicle_models` (
  `id` INTEGER NOT NULL,
  `slug` TEXT DEFAULT NULL,
  `make_id` INTEGER NOT NULL,
  `name` TEXT NOT NULL,
  `autotrader_id` TEXT DEFAULT NULL,
  `cap_id` TEXT DEFAULT NULL,
  `created_at` TEXT NULL DEFAULT NULL,
  `updated_at` TEXT NULL DEFAULT NULL,
  `do_not_sync` INTEGER DEFAULT NULL,
  `lcv_cap_id` TEXT DEFAULT NULL,
  `type` TEXT DEFAULT NULL,
  `keyloop_id` TEXT DEFAULT NULL,
  PRIMARY KEY (`id`)
);

CREATE INDEX "api_tokens_api_user_id_index" on "api_tokens" ("api_user_id");
CREATE INDEX "api_tokens_token_type_index" on "api_tokens" ("token_type");
CREATE INDEX "api_tokens_token_index" on "api_tokens" ("token");
CREATE INDEX "api_tokens_expires_at_index" on "api_tokens" ("expires_at");
CREATE INDEX "api_usage_tenant_id_index" on "api_usage" ("tenant_id");
CREATE INDEX "api_usage_endpoint_index" on "api_usage" ("endpoint");
CREATE INDEX "api_usage_method_index" on "api_usage" ("method");
CREATE INDEX "api_usage_time_window_index" on "api_usage" ("time_window");
CREATE INDEX "api_usage_hits_index" on "api_usage" ("hits");
CREATE INDEX "api_usage_avg_index" on "api_usage" ("avg");
CREATE INDEX "api_usage_min_index" on "api_usage" ("min");
CREATE INDEX "api_usage_max_index" on "api_usage" ("max");
CREATE INDEX "api_usage_user_id" on "api_usage" ("api_user_id");
CREATE INDEX "api_usage_token_id" on "api_usage" ("api_token_id");
CREATE INDEX "api_usage_snapshots_api_usage_id_index" on "api_usage_snapshots" ("api_usage_id");
CREATE INDEX "api_usage_snapshots_request_time_index" on "api_usage_snapshots" ("request_time");
CREATE INDEX "api_user_tenants_api_user_id_index" on "api_user_tenants" ("api_user_id");
CREATE INDEX "api_user_tenants_tenant_id_index" on "api_user_tenants" ("tenant_id");
CREATE INDEX "api_users_client_id_client_secret_index" on "api_users" ("client_id","client_secret");
CREATE INDEX "api_users_is_active_index" on "api_users" ("is_active");
CREATE INDEX "api_users_credentials_due_for_update_at_index" on "api_users" ("credentials_due_for_update_at");
CREATE INDEX "billables_code_index" on "billables" ("code");
CREATE INDEX "billables_type_index" on "billables" ("type");
CREATE INDEX "billables_active_index" on "billables" ("active");
CREATE INDEX "body_styles_autotrader_id_index" on "body_styles" ("autotrader_id");
CREATE INDEX "body_styles_slug_index" on "body_styles" ("slug");
CREATE INDEX "body_styles_type_index" on "body_styles" ("type");
CREATE INDEX "content_syncs_tenant_id_index" on "content_syncs" ("tenant_id");
CREATE INDEX "content_syncs_token_index" on "content_syncs" ("token");
CREATE UNIQUE INDEX "countries_code_unique" on "countries" ("code");
CREATE INDEX "countries_status_index" on "countries" ("status");
CREATE INDEX "countries_order_index" on "countries" ("order");
CREATE INDEX "countries_code_index" on "countries" ("code");
CREATE INDEX "countries_name_index" on "countries" ("name");
CREATE INDEX "countries_currency_code_index" on "countries" ("currency_code");
CREATE INDEX "countries_iso_code_index" on "countries" ("iso_code");
CREATE INDEX "countries_is_eu_index" on "countries" ("is_eu");
CREATE INDEX "countries_has_postcodes_index" on "countries" ("has_postcodes");
CREATE UNIQUE INDEX "currencies_code_unique" on "currencies" ("code");
CREATE UNIQUE INDEX "domains_domain_unique" on "domains" ("domain");
CREATE INDEX "domains_tenant_id_foreign" on "domains" ("tenant_id");
CREATE INDEX "drivetrains_autotrader_id_index" on "drivetrains" ("autotrader_id");
CREATE INDEX "drivetrains_slug_index" on "drivetrains" ("slug");
CREATE INDEX "export_map_templates_is_published_index" on "export_map_templates" ("is_published");
CREATE INDEX "export_map_templates_sales_channel_index" on "export_map_templates" ("sales_channel");
CREATE INDEX "export_map_templates_type_index" on "export_map_templates" ("type");
CREATE UNIQUE INDEX "ext_serv_usage_unique" on "external_service_usage" ("tenant_id","service","section","created_at");
CREATE INDEX "external_service_usage_tenant_id_service_section_index" on "external_service_usage" ("tenant_id","service","section");
CREATE UNIQUE INDEX "failed_jobs_uuid_unique" on "failed_jobs" ("uuid");
CREATE INDEX "failed_jobs_failed_at_index" on "failed_jobs" ("failed_at");
CREATE INDEX "fuel_types_autotrader_id_index" on "fuel_types" ("autotrader_id");
CREATE INDEX "fuel_types_slug_index" on "fuel_types" ("slug");
CREATE INDEX "go_live_tasks_tenant_id_index" on "go_live_tasks" ("tenant_id");
CREATE INDEX "go_live_tasks_task_index" on "go_live_tasks" ("task");
CREATE INDEX "go_live_tasks_last_triggered_at_index" on "go_live_tasks" ("last_triggered_at");
CREATE INDEX "go_live_tasks_completed_at_index" on "go_live_tasks" ("completed_at");
CREATE INDEX "go_live_tasks_failed_at_index" on "go_live_tasks" ("failed_at");
CREATE INDEX "go_live_tasks_completed_by_index" on "go_live_tasks" ("completed_by");
CREATE INDEX "invoice_addresses_invoice_id_index" on "invoice_addresses" ("invoice_id");
CREATE INDEX "invoice_addresses_type_index" on "invoice_addresses" ("type");
CREATE INDEX "invoice_history_invoice_id_index" on "invoice_history" ("invoice_id");
CREATE INDEX "invoice_history_type_index" on "invoice_history" ("type");
CREATE INDEX "invoice_items_invoice_id_index" on "invoice_items" ("invoice_id");
CREATE INDEX "invoice_items_billable_id_index" on "invoice_items" ("billable_id");
CREATE INDEX "invoice_payments_invoice_id_index" on "invoice_payments" ("invoice_id");
CREATE INDEX "invoice_payments_provider_index" on "invoice_payments" ("provider");
CREATE INDEX "invoice_payments_reference_index" on "invoice_payments" ("reference");
CREATE INDEX "invoice_payments_confirmed_at_index" on "invoice_payments" ("confirmed_at");
CREATE INDEX "invoices_tenant_id_index" on "invoices" ("tenant_id");
CREATE INDEX "invoices_email_index" on "invoices" ("email");
CREATE INDEX "invoices_status_index" on "invoices" ("status");
CREATE INDEX "invoices_paid_at_index" on "invoices" ("paid_at");
CREATE INDEX "model_has_permissions_model_id_model_type_index" on "model_has_permissions" ("model_id","model_type");
CREATE INDEX "model_has_permissions_team_foreign_key_index" on "model_has_permissions" ("tenant_id");
CREATE INDEX "model_has_roles_model_id_model_type_index" on "model_has_roles" ("model_id","model_type");
CREATE INDEX "model_has_roles_team_foreign_key_index" on "model_has_roles" ("tenant_id");
CREATE INDEX "password_resets_email_index" on "password_resets" ("email");
CREATE UNIQUE INDEX "permissions_name_guard_name_unique" on "permissions" ("name","guard_name");
CREATE UNIQUE INDEX "personal_access_tokens_token_unique" on "personal_access_tokens" ("token");
CREATE INDEX "personal_access_tokens_tokenable_type_tokenable_id_index" on "personal_access_tokens" ("tokenable_type","tokenable_id");
CREATE INDEX "postcode_cache_country_index" on "postcode_cache" ("country");
CREATE INDEX "postcode_cache_postcode_index" on "postcode_cache" ("postcode");
CREATE INDEX "release_notes_is_published_index" on "release_notes" ("is_published");
CREATE INDEX "release_notes_published_at_index" on "release_notes" ("published_at");
CREATE INDEX "role_has_permissions_role_id_foreign" on "role_has_permissions" ("role_id");
CREATE UNIQUE INDEX "roles_tenant_id_name_guard_name_unique" on "roles" ("tenant_id","name","guard_name");
CREATE INDEX "roles_team_foreign_key_index" on "roles" ("tenant_id");
CREATE INDEX "roles_tenant_index" on "roles" ("tenant");
CREATE INDEX "seeds_seeder_index" on "seeds" ("seeder");
CREATE INDEX "system_alerts_last_sent_at_index" on "system_alerts" ("last_sent_at");
CREATE INDEX "system_alerts_alert_type_index" on "system_alerts" ("alert_type");
CREATE INDEX "taxonomy_map_taxonomy_type_taxonomy_id_index" on "taxonomy_map" ("taxonomy_type","taxonomy_id");
CREATE INDEX "taxonomy_map_term_index" on "taxonomy_map" ("term");
CREATE INDEX "taxonomy_map_provider_index" on "taxonomy_map" ("provider");
CREATE INDEX "taxonomy_map_parent_id_index" on "taxonomy_map" ("parent_id");
CREATE INDEX "taxonomy_mapables_taxonomy_map_id_index" on "taxonomy_mapables" ("taxonomy_map_id");
CREATE INDEX "taxonomy_mapables_mappable_type_mappable_id_index" on "taxonomy_mapables" ("mappable_type","mappable_id");
CREATE UNIQUE INDEX "telescope_entries_uuid_unique" on "telescope_entries" ("uuid");
CREATE INDEX "telescope_entries_batch_id_index" on "telescope_entries" ("batch_id");
CREATE INDEX "telescope_entries_family_hash_index" on "telescope_entries" ("family_hash");
CREATE INDEX "telescope_entries_created_at_index" on "telescope_entries" ("created_at");
CREATE INDEX "telescope_entries_type_should_display_on_index_index" on "telescope_entries" ("type","should_display_on_index");
CREATE INDEX "telescope_entries_tags_entry_uuid_tag_index" on "telescope_entries_tags" ("entry_uuid","tag");
CREATE INDEX "telescope_entries_tags_tag_index" on "telescope_entries_tags" ("tag");
CREATE INDEX "tenant_billables_tenant_id_index" on "tenant_billables" ("tenant_id");
CREATE INDEX "tenant_billables_billable_id_index" on "tenant_billables" ("billable_id");
CREATE INDEX "tenant_billables_billed_from_index" on "tenant_billables" ("billed_from");
CREATE INDEX "tenant_billables_billed_until_index" on "tenant_billables" ("billed_until");
CREATE INDEX "tenant_billing_details_tenant_id_index" on "tenant_billing_details" ("tenant_id");
CREATE UNIQUE INDEX "tenant_feature_entry" on "tenant_features" ("tenant_id","feature");
CREATE INDEX "tenant_features_feature_index" on "tenant_features" ("feature");
CREATE INDEX "tenant_users_user_id_index" on "tenant_users" ("user_id");
CREATE INDEX "tenant_users_tenant_id_index" on "tenant_users" ("tenant_id");
CREATE INDEX "tenants_name_index" on "tenants" ("name");
CREATE INDEX "tenants_suspended_at_index" on "tenants" ("suspended_at");
CREATE INDEX "tenants_suspended_by_index" on "tenants" ("suspended_by");
CREATE INDEX "tenants_last_invoice_created_at_index" on "tenants" ("last_invoice_created_at");
CREATE INDEX "tenants_next_invoice_due_at_index" on "tenants" ("next_invoice_due_at");
CREATE INDEX "tenants_tier_index" on "tenants" ("tier");
CREATE INDEX "tenants_live_at_index" on "tenants" ("live_at");
CREATE INDEX "tenants_marked_live_by_index" on "tenants" ("marked_live_by");
CREATE INDEX "tenants_has_cloudflare_index" on "tenants" ("has_cloudflare");
CREATE INDEX "transmissions_autotrader_id_index" on "transmissions" ("autotrader_id");
CREATE INDEX "transmissions_slug_index" on "transmissions" ("slug");
CREATE UNIQUE INDEX "two_factor_remembered_devices_token_unique" on "two_factor_remembered_devices" ("token");
CREATE INDEX "two_factor_remembered_devices_user_id_token_index" on "two_factor_remembered_devices" ("user_id","token");
CREATE UNIQUE INDEX "user_dashboard_widgets_tenant_id_user_id_section_position_unique" on "user_dashboard_widgets" ("tenant_id","user_id","section","position");
CREATE INDEX "user_dashboard_widgets_tenant_id_index" on "user_dashboard_widgets" ("tenant_id");
CREATE INDEX "user_dashboard_widgets_section_index" on "user_dashboard_widgets" ("section");
CREATE INDEX "user_dashboard_widgets_position_index" on "user_dashboard_widgets" ("position");
CREATE UNIQUE INDEX "user_favourite_sites_user_id_tenant_id_unique" on "user_favourite_sites" ("user_id","tenant_id");
CREATE INDEX "user_favourite_sites_tenant_id_index" on "user_favourite_sites" ("tenant_id");
CREATE UNIQUE INDEX "users_email_unique" on "users" ("email");
CREATE INDEX "valuations_created_at_index" on "valuations" ("created_at");
CREATE INDEX "valuations_user_id_index" on "valuations" ("user_id");
CREATE INDEX "valuations_provider_index" on "valuations" ("provider");
CREATE INDEX "valuations_registration_index" on "valuations" ("registration");
CREATE INDEX "valuations_mileage_index" on "valuations" ("mileage");
CREATE INDEX "valuations_valuation_made_at_index" on "valuations" ("valuation_made_at");
CREATE INDEX "vehicle_makes_autotrader_id_index" on "vehicle_makes" ("autotrader_id");
CREATE INDEX "vehicle_makes_cap_id_index" on "vehicle_makes" ("cap_id");
CREATE INDEX "vehicle_makes_lcv_cap_id_index" on "vehicle_makes" ("lcv_cap_id");
CREATE INDEX "vehicle_makes_slug_index" on "vehicle_makes" ("slug");
CREATE INDEX "vehicle_makes_keyloop_id_index" on "vehicle_makes" ("keyloop_id");
CREATE INDEX "vehicle_makes_cars_index" on "vehicle_makes" ("cars");
CREATE INDEX "vehicle_makes_lcvs_index" on "vehicle_makes" ("lcvs");
CREATE INDEX "vehicle_makes_motorcycles_index" on "vehicle_makes" ("motorcycles");
CREATE INDEX "vehicle_models_autotrader_id_index" on "vehicle_models" ("autotrader_id");
CREATE INDEX "vehicle_models_cap_id_index" on "vehicle_models" ("cap_id");
CREATE INDEX "vehicle_models_do_not_sync_index" on "vehicle_models" ("do_not_sync");
CREATE INDEX "vehicle_models_lcv_cap_id_index" on "vehicle_models" ("lcv_cap_id");
CREATE INDEX "vehicle_models_slug_index" on "vehicle_models" ("slug");
CREATE INDEX "vehicle_models_type_index" on "vehicle_models" ("type");
CREATE INDEX "vehicle_models_keyloop_id_index" on "vehicle_models" ("keyloop_id");

INSERT INTO migrations VALUES(1,'2014_10_12_000000_create_users_table',1);
INSERT INTO migrations VALUES(2,'2014_10_12_100000_create_password_resets_table',1);
INSERT INTO migrations VALUES(3,'2014_10_12_200000_add_two_factor_columns_to_users_table',1);
INSERT INTO migrations VALUES(4,'2018_08_08_100000_create_telescope_entries_table',1);
INSERT INTO migrations VALUES(5,'2018_08_20_145346_add_countries_table',1);
INSERT INTO migrations VALUES(6,'2019_08_19_000000_create_failed_jobs_table',1);
INSERT INTO migrations VALUES(7,'2019_09_15_000010_create_tenants_table',1);
INSERT INTO migrations VALUES(8,'2019_09_15_000020_create_domains_table',1);
INSERT INTO migrations VALUES(9,'2021_10_11_074532_create_tenant_users_table',1);
INSERT INTO migrations VALUES(10,'2021_10_20_062242_add_user_profile_picture',1);
INSERT INTO migrations VALUES(11,'2021_10_29_071309_create_permission_tables',1);
INSERT INTO migrations VALUES(12,'2022_01_25_091629_create_vehicle_taxonomy_tables',1);
INSERT INTO migrations VALUES(13,'2022_02_17_071848_create_invoice_tables',1);
INSERT INTO migrations VALUES(14,'2022_02_17_122356_add_invoice_data_to_tenants',1);
INSERT INTO migrations VALUES(15,'2022_02_17_122621_create_tenant_billing_details_table',1);
INSERT INTO migrations VALUES(16,'2022_02_17_122633_create_tenant_billables_table',1);
INSERT INTO migrations VALUES(17,'2022_02_17_122642_create_billables_table',1);
INSERT INTO migrations VALUES(18,'2022_04_12_061712_create_currencies_table',1);
INSERT INTO migrations VALUES(19,'2022_05_17_134356_add_domain_columns',1);
INSERT INTO migrations VALUES(20,'2022_07_20_093204_create_taxonomy_map_table',1);
INSERT INTO migrations VALUES(21,'2022_11_04_142305_add_field_segmentation_to_fuel_types',1);
INSERT INTO migrations VALUES(22,'2023_03_21_111927_add_details_to_taxonomy_map',1);
INSERT INTO migrations VALUES(23,'2019_12_14_000001_create_personal_access_tokens_table',2);
INSERT INTO migrations VALUES(24,'2022_10_06_141514_create_valuations_table',2);
INSERT INTO migrations VALUES(25,'2023_04_18_083106_fix_model_has_roles_tenant_column',2);
INSERT INTO migrations VALUES(26,'2023_05_12_132621_add_colors_to_vehicle_makes',3);
INSERT INTO migrations VALUES(27,'2023_06_01_134016_create_user_dashboard_widgets',4);
INSERT INTO migrations VALUES(28,'2023_06_12_114504_create_content_syncs_table',5);
INSERT INTO migrations VALUES(29,'2023_06_21_091614_add_data_to_content_syncs',6);
INSERT INTO migrations VALUES(30,'2023_07_17_082149_update_vehicle_type_from_valuations_table',7);
INSERT INTO migrations VALUES(31,'2023_07_24_085803_create_tenant_features_table',7);
INSERT INTO migrations VALUES(32,'2023_07_27_161415_update_taxonomy_map_details_type',7);
INSERT INTO migrations VALUES(33,'2023_09_21_082149_add_colour_to_valuations_table',8);
INSERT INTO migrations VALUES(34,'2023_11_09_124323_create_postcode_cache_table',9);
INSERT INTO migrations VALUES(35,'2021_04_15_091933_create_motor_check_tables',10);
INSERT INTO migrations VALUES(36,'2024_01_17_080724_add_force_to_domains',11);
INSERT INTO migrations VALUES(37,'2024_01_18_134848_add_parent_id_to_taxonomy_map',12);
INSERT INTO migrations VALUES(38,'2024_01_26_092235_remove_motor_check_tables_from_master_db',13);
INSERT INTO migrations VALUES(39,'2024_01_29_145531_add_primary_key_to_model_has_roles_table',14);
INSERT INTO migrations VALUES(40,'2024_07_18_080342_add_do_not_sync_to_vehicle_models',15);
INSERT INTO migrations VALUES(41,'2024_08_13_111032_add_cap_data_to_vehicle_makes_and_vehicle_models',16);
INSERT INTO migrations VALUES(42,'2024_08_14_140512_add_tenant_to_roles',16);
INSERT INTO migrations VALUES(43,'2024_09_25_101805_create_taxonomy_mapables_table',17);
INSERT INTO migrations VALUES(44,'2024_08_27_124734_create_seeds_table',18);
INSERT INTO migrations VALUES(45,'2024_10_28_091900_add_taxonomy_slug_on_main_models',19);
INSERT INTO migrations VALUES(46,'2024_11_12_151544_create_system_alerts_table',20);
INSERT INTO migrations VALUES(47,'2024_12_18_074508_add_port_number_to_tenants',21);
INSERT INTO migrations VALUES(48,'2025_02_10_144025_create_api_usage_table',22);
INSERT INTO migrations VALUES(49,'2025_02_12_162627_create_external_service_usage_table',23);
INSERT INTO migrations VALUES(50,'2025_03_15_082657_add_live_at_to_tenants',24);
INSERT INTO migrations VALUES(51,'2025_03_26_094915_add_cloudflare_data_to_tenants',25);
INSERT INTO migrations VALUES(52,'2025_04_01_082149_add_data_to_valuations_table',26);
INSERT INTO migrations VALUES(53,'2025_05_19_075604_create_release_notes_table',27);
INSERT INTO migrations VALUES(54,'2025_06_10_074910_add_type_to_vehicle_models',28);
INSERT INTO migrations VALUES(55,'2025_07_08_100000_add_type_to_tenants',29);
INSERT INTO migrations VALUES(56,'2025_07_21_143400_add_keyloop_ids_to_makes_and_models_tables',30);
INSERT INTO migrations VALUES(57,'2025_08_28_122923_create_api_users_table',31);
INSERT INTO migrations VALUES(58,'2025_09_08_131200_add_vehicle_type_to_vehicle_make_table',32);
INSERT INTO migrations VALUES(59,'2025_06_02_153002_create_go_live_tasks_table',33);
INSERT INTO migrations VALUES(60,'2025_09_08_100000_create_export_map_templates_table',34);
INSERT INTO migrations VALUES(61,'2025_12_01_120010_create_user_favourite_sites_table',35);
INSERT INTO migrations VALUES(62,'2025_12_02_084855_add_indices_to_api_usage',36);
INSERT INTO migrations VALUES(63,'2025_12_20_120000_add_slow_request_columns_to_api_usage',37);
INSERT INTO migrations VALUES(64,'2025_12_20_130000_add_time_window_index_to_api_usage',37);
INSERT INTO migrations VALUES(65,'2026_01_08_150000_create_two_factor_remembered_devices_table',38);
