<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('vehicle_autotrader_data', function (Blueprint $table) {
            $table->unsignedBigInteger('ad_views_7d')->nullable()->after('ad_views');
            $table->string('performance_rating', 50)->nullable();
            $table->string('lead_count_rating', 50)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('vehicle_autotrader_data', function (Blueprint $table) {
            $table->dropColumn([
                'ad_views_7d',
                'performance_rating',
                'lead_count_rating'
            ]);
        });
    }
};
