<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('resource_views', function (Blueprint $table) {
            $table->id();
            $table->string('viewable_type', 50)->index();
            $table->unsignedBigInteger('viewable_id')->index();
            $table->date('date')->index();
            $table->unsignedInteger('hits')->default(0);
            $table->unsignedInteger('quick_view_hits')->nullable();
            $table->unsignedInteger('filter_views')->nullable();
            $table->unsignedInteger('compare_views')->nullable();
            $table->unsignedInteger('compare_email_requests')->nullable();
            $table->timestamps();

            // Composite indexes for efficient queries
            $table->unique(['viewable_type', 'viewable_id', 'date'], 'resource_views_unique');
            $table->index(['viewable_type', 'date'], 'resource_views_type_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('resource_views');
    }
};
