<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('queue_process_logs', function (Blueprint $table) {
            $table->id();
            $table->string('process_type')->index();
            $table->string('provider')->nullable()->index();
            $table->string('status')->default('running')->index();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('finished_at')->nullable();
            $table->unsignedInteger('duration_seconds')->nullable();
            $table->unsignedInteger('items_processed')->nullable();
            $table->unsignedInteger('items_created')->nullable();
            $table->unsignedInteger('items_updated')->nullable();
            $table->unsignedInteger('items_failed')->nullable();
            $table->text('error_message')->nullable();
            $table->json('error_details')->nullable();
            $table->json('metadata')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('queue_process_logs');
    }
};
