<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('export_maps', 'config') === false) {
            Schema::table('export_maps', function (Blueprint $table) {
                $table->json('config')->nullable()->after('format');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('export_maps', function (Blueprint $table) {
            $table->dropColumn('config');
        });
    }
};
