<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_autotrader_data', function (Blueprint $table) {
            $table->string('derivative_id')->nullable();
            $table->string('at_export_error')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_autotrader_data', function (Blueprint $table) {
            $table->dropColumn([
                'derivative_id',
                'at_export_error',
            ]);
        });
    }
};
