<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_autotrader_data', function (Blueprint $table) {
            $table->boolean('publish_advert')->nullable();
            $table->boolean('publish_profile')->nullable();
            $table->string('advert_publish_state', 50)->nullable();
            $table->string('profile_publish_state', 50)->nullable();
            $table->string('lifecycle_state', 50)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_autotrader_data', function (Blueprint $table) {
            $table->dropColumn([
                'publish_advert',
                'publish_profile',
                'advert_publish_state',
                'profile_publish_state',
                'lifecycle_state',
            ]);
        });
    }
};
