<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicle_reviews', function (Blueprint $table) {
            $table->id();
            $table->string('provider')->index();
            $table->string('external_review_id')->nullable()->index();
            $table->mediumText('review')->nullable();
            $table->text('meta')->nullable();
            $table->timestamps();
        });

        Schema::create('vehicle_review_uses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')->constrained('vehicles')->onDelete('cascade');
            $table->foreignId('vehicle_review_id')->constrained('vehicle_reviews')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicle_reviews');
        Schema::dropIfExists('vehicle_review_uses');
    }
};
