<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_trims', function (Blueprint $table) {
            $table->text('data')->nullable();
        });
        Schema::table('new_cars', function (Blueprint $table) {
            $table->string('vehicle_type')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_trims', function (Blueprint $table) {
            $table->dropColumn('data');
        });
        Schema::table('new_cars', function (Blueprint $table) {
            $table->dropColumn('vehicle_type');
        });
    }
};
