<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vehicle_stock_sync_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vehicle_id')
                ->constrained()
                ->onDelete('cascade');

            $table->string('provider')->index();
            $table->enum('action', ['import', 'export'])->index();
            $table->mediumText('data')->nullable();
            $table->boolean('processed')->nullable()->index();
            $table->timestamp('synced_at')->nullable()->index();
            $table->timestamps();
            $table->index(['vehicle_id', 'synced_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vehicle_stock_sync_logs');
    }
};
