<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('keyloop_lease_vehicle_variants', function (Blueprint $table) {
            $table->id();

            $table->string('external_variant_id', 50)->index();
            $table->string('slug')->nullable()->index();
            $table->foreignId('make_id')->index()->nullable();
            $table->foreignId('model_id')->index()->nullable();
            $table->string('name', 255)->nullable();
            $table->boolean('is_current_variant')->default(true);
            $table->boolean('is_cheapest_variant')->default(false);
            $table->string('type', 20)->nullable()->index;
            $table->foreignId('body_style_id')->index()->nullable();
            $table->foreignId('transmission_id')->index()->nullable();
            $table->foreignId('fuel_type_id')->index()->nullable();
            $table->integer('engine_size_cc')->nullable();
            $table->integer('brake_horsepower')->nullable();
            $table->integer('co2')->nullable();
            $table->smallInteger('door_count')->nullable();
            $table->smallInteger('seats')->nullable();
            $table->decimal('road_fund_licence')->nullable();
            $table->decimal('price_ex_vat_ex_vrt', 10, 2)->index()->nullable();
            $table->decimal('price_inc_vat_ex_vrt', 10, 2)->index()->nullable();
            $table->decimal('vehicle_vrt', 10, 2)->nullable()->comment('Vehicle Registration Tax applicable to the vehicle');
            $table->decimal('price_inc_vat_inc_vrt', 10, 2)->index()->nullable();
            $table->decimal('delivery_ex_vat_ex_vrt', 10, 2)->index()->nullable();
            $table->decimal('delivery_inc_vat_ex_vrt', 10, 2)->index()->nullable();
            $table->decimal('delivery_vrt', 10, 2)->nullable()->comment('Vehicle Registration Tax applicable to delivery cost');
            $table->decimal('delivery_inc_vat_inc_vrt', 10, 2)->index()->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);
            $table->boolean('featured')->index()->default(false);
            $table->decimal('cheapest_monthly_price_ex_vat')->index('keyloop_lease_variant_cheapest_monthly_ex_vat')->nullable();
            $table->decimal('cheapest_monthly_price_inc_vat')->index('keyloop_lease_variant_cheapest_monthly_inc_vat')->nullable();

            $table->timestamps();
        });

        Schema::create('keyloop_lease_residual_values', function (Blueprint $table) {
            $table->id();

            $table->string('external_variant_id', 50)->index();
            $table->integer('contract_length')->index();
            $table->integer('annual_mileage')->index();
            $table->decimal('residual_value_excluding_vat', 10, 2)->nullable();
            $table->decimal('residual_value_including_vat', 10, 2)->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });

        Schema::create('keyloop_lease_options', function (Blueprint $table) {
            $table->id();

            $table->string('external_variant_id', 50)->index()->nullable();
            $table->foreignId('make_id')->index()->nullable();
            $table->foreignId('model_id')->index()->nullable();
            $table->string('option_type', 50)->index()->nullable();
            $table->string('option_code', 50)->index()->nullable();
            $table->string('default_vat_code', 50)->index()->nullable();
            $table->string('name', 255)->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });

        Schema::create('keyloop_lease_option_categories', function (Blueprint $table) {
            $table->id();

            $table->string('option_code', 50)->index()->nullable();
            $table->string('name', 255)->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });

        Schema::create('keyloop_lease_option_prices', function (Blueprint $table) {
            $table->id();

            $table->string('external_variant_id', 50)->index()->nullable();
            $table->foreignId('make_id')->index()->nullable();
            $table->foreignId('model_id')->index()->nullable();
            $table->string('option_code', 50)->index()->nullable();
            $table->decimal('price_ex_vat_ex_vrt', 10, 2)->index()->nullable();
            $table->decimal('price_inc_vat_inc_vrt', 10, 2)->index()->nullable();
            $table->decimal('vrt', 10, 2)->index()->nullable()->comment('Vehicle Registration Tax applicable to the option price');
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });

        Schema::create('keyloop_lease_option_price_mapping', function (Blueprint $table) {
            $table->id();

            $table->string('external_variant_id', 50)->index()->nullable();
            $table->foreignId('make_id')->index()->nullable();
            $table->foreignId('model_id')->index()->nullable();
            $table->string('option_type', 50)->index()->nullable();
            $table->string('option_code', 50)->index()->nullable();
            $table->string('price_option_code', 50)->index()->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });

        Schema::create('keyloop_lease_variant_option_mapping', function (Blueprint $table) {
            $table->id();

            $table->string('external_variant_id', 50)->index()->nullable();
            $table->foreignId('make_id')->index()->nullable();
            $table->foreignId('model_id')->index()->nullable();
            $table->string('option_type', 50)->index()->nullable();
            $table->string('option_code', 50)->index()->nullable();
            $table->string('option_availability_code', 50)->index('opt_avail_code')->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });

        Schema::create('keyloop_lease_colours', function (Blueprint $table) {
            $table->id();

            $table->foreignId('make_id')->index()->nullable();
            $table->string('colour_code', 50)->index()->nullable();
            $table->string('generic_colour_code', 50)->index()->nullable();
            $table->string('name', 255)->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });

        Schema::create('keyloop_lease_discounts', function (Blueprint $table) {
            $table->id();

            $table->string('external_variant_id', 50)->index()->nullable();
            $table->foreignId('make_id')->index()->nullable();
            $table->foreignId('model_id')->index()->nullable();
            $table->string('discount_type', 50)->nullable();
            $table->decimal('discount_amount', 10, 2)->nullable();
            $table->boolean('was_recently_synced')->index()->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('keyloop_lease_vehicle_variants');
        Schema::dropIfExists('keyloop_lease_residual_values');
        Schema::dropIfExists('keyloop_lease_options');
        Schema::dropIfExists('keyloop_lease_option_prices');
        Schema::dropIfExists('keyloop_lease_option_price_mapping');
        Schema::dropIfExists('keyloop_lease_variant_option_mapping');
        Schema::dropIfExists('keyloop_lease_colours');
        Schema::dropIfExists('keyloop_lease_discounts');
    }
};
