<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_trims', function (Blueprint $table) {
            $table->string('cap_id')->index()->nullable();
            $table->decimal('full_price', 12)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_trims', function (Blueprint $table) {
            $table->dropColumn('cap_id');
            $table->dropColumn('full_price');
        });
    }
};
