<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('export_map_fields');
        Schema::table('export_maps', function (Blueprint $table) {
            $table->dropColumn('data');
            $table->text('columns')->nullable()->after('conditions');
            $table->boolean('include_header_row')->default(1);
            $table->boolean('ftp_export_enabled')->default(0);
            $table->boolean('schedule_enabled')->default(0)->after('schedule');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::create('export_map_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('map_id')->index();
            $table->string('on_file');
            $table->string('on_model')->nullable();
            $table->string('default_value')->nullable();
            $table->timestamps();
        });

        Schema::table('export_maps', function (Blueprint $table) {
            $table->text('data')->nullable();
            $table->string('filename')->nullable();
            $table->dropColumn('columns');
            $table->dropColumn('include_header_row');
            $table->dropColumn('ftp_export_enabled');
            $table->dropColumn('schedule_enabled');
        });
    }
};
