<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('export_maps', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->index();
            $table->string('type')->index();
            $table->text('data')->nullable();
            $table->string('export_time', 6)->nullable();
            $table->smallInteger('export_day_of_week')->nullable();
            $table->smallInteger('export_day_of_month')->nullable();
            $table->boolean('active')->default(0)->index();
            $table->string('schedule', 30)->nullable();
            $table->string('format', 30)->nullable();
            $table->text('conditions')->nullable();
            $table->dateTime('last_sent_at')->nullable()->index();
            $table->dateTime('next_due_at')->nullable()->index();
            $table->string('driver')->nullable();
            $table->string('host')->nullable();
            $table->string('root')->nullable()->default('/');
            $table->string('username')->nullable();
            $table->string('password')->nullable();
            $table->string('filename')->nullable();
            $table->timestamps();
        });

        Schema::create('export_map_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('map_id')->index();
            $table->string('on_file');
            $table->string('on_model')->nullable();
            $table->string('default_value')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('export_maps');
        Schema::dropIfExists('export_map_fields');
    }
};
