<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            Schema::create('new_car_fuel_types', function (Blueprint $table) {
                $table->id();
                $table->foreignId('new_car_id')->index();
                $table->foreignId('fuel_type_id')->index();
                $table->timestamps();
            });

            $data = DB::table('new_cars')
                ->whereNotNull('fuel_type_id')
                ->select('id', 'fuel_type_id')
                ->get()
                ->map(function ($item) {
                    return [
                        'new_car_id' => $item->id,
                        'fuel_type_id' => $item->fuel_type_id,
                    ];
                });

            DB::table('new_car_fuel_types')->insert($data->all());

            Schema::table('new_cars', function (Blueprint $table) {
                $table->dropColumn('fuel_type_id');
            });
        } catch (\Exception $exception) {
            dump( $exception->getMessage());
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('new_car_fuel_types');

        Schema::table('new_cars', function (Blueprint $table) {
            $table->foreignId('fuel_type_id')->nullable()->index();
        });
    }
};
